/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public interface IAdvancedItemHandler
extends IItemHandler {
    default public ItemStack insertItem(ItemStack stack, boolean simulate) {
        ItemStack remainder = stack.m_41777_();
        for (int slot = 0; slot < this.getSlots() && !(remainder = this.insertItem(slot, stack, simulate)).m_41619_(); ++slot) {
        }
        return remainder;
    }

    default public boolean hasSpaceFor(List<ItemStack> stacks) {
        return this.hasSpaceFor(stacks, 0, this.getSlots());
    }

    default public boolean hasSpaceFor(List<ItemStack> stacks, int startInclusive, int endExclusive) {
        if (stacks.isEmpty()) {
            return true;
        }
        if (stacks.size() == 1) {
            ItemStack remainder = stacks.get(0).m_41777_();
            for (int slot = startInclusive; slot < endExclusive; ++slot) {
                if (!(remainder = this.insertItem(slot, remainder, true)).m_41619_()) continue;
                return true;
            }
            return remainder.m_41619_();
        }
        HashMap<Integer, ItemStack> copies = new HashMap<Integer, ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            int amountLeft = stack.m_41613_();
            for (int slot = startInclusive; slot < endExclusive; ++slot) {
                if (!this.isItemValid(slot, stack)) continue;
                ItemStack content = copies.getOrDefault(slot, this.getStackInSlot(slot));
                if (content.m_41619_()) {
                    amountLeft = 0;
                    ItemStack modifiableStack = stack.m_41777_();
                    modifiableStack.m_41764_(amountLeft);
                    copies.put(slot, modifiableStack);
                    break;
                }
                if (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)content) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)content)) continue;
                int reduce = Math.max(0, Math.min(content.m_41741_() - content.m_41613_(), amountLeft));
                ItemStack modifiableStack = copies.getOrDefault(slot, this.getStackInSlot(slot).m_41777_());
                modifiableStack.m_41769_(reduce);
                copies.put(slot, modifiableStack);
                if ((amountLeft -= reduce) <= 0) break;
            }
            if (amountLeft <= 0) continue;
            return false;
        }
        return true;
    }

    default public ItemStack extractItem(int amount, boolean simulate) {
        return this.extractItem(stack -> true, amount, simulate);
    }

    default public ItemStack extractItem(Predicate<ItemStack> predicate, int amount, boolean simulate) {
        ItemStack extracted = ItemStack.f_41583_;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            int amountToExtract = Math.max(0, amount - extracted.m_41613_());
            ItemStack content = this.extractItem(slot, amountToExtract, true);
            if (extracted.m_41619_()) {
                if (predicate.test(content)) {
                    extracted = content;
                    if (!simulate) {
                        this.extractItem(slot, amountToExtract, true);
                    }
                }
            } else {
                if (ItemStack.m_41746_((ItemStack)extracted, (ItemStack)content) && ItemStack.m_41658_((ItemStack)extracted, (ItemStack)content)) {
                    extracted.m_41769_(content.m_41613_());
                }
                if (!simulate) {
                    this.extractItem(slot, amountToExtract, true);
                }
            }
            if (extracted.m_41613_() >= amount) break;
        }
        return extracted;
    }

    public static IAdvancedItemHandler wrap(final IItemHandler handler) {
        if (handler instanceof IAdvancedItemHandler) {
            IAdvancedItemHandler advanced = (IAdvancedItemHandler)handler;
            return advanced;
        }
        return new IAdvancedItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }
        };
    }
}

